#!/usr/bin/env bash

set -e
shopt -s extglob

if [[ $* == *--help* ]]; then
    echo "Usage: $0 [--help] [--uninstall] [--accept-eula]"
    exit 0
fi

VERB="Installing"
if [[ $* == *--uninstall* ]]; then
    VERB="Uninstalling"
    UNINSTALL=1
fi


FORCE_INSTALL=0
if [[ $* == *--force-install* ]]; then
    FORCE_INSTALL=1
fi

amf_installer_show_eula() {
    PAGER=more
    if ! which -s $PAGER; then
        PAGER=less
    fi
    if ! which -s $PAGER; then
        PAGER=cat
    fi
    $PAGER <<EOF
    END USER LICENSE AGREEMENT

IMPORTANT-READ CAREFULLY: DO NOT INSTALL, COPY OR USE THE ENCLOSED SOFTWARE,
DOCUMENTATION (AS DEFINED BELOW), OR ANY PORTION THEREOF, UNTIL YOU HAVE
CAREFULLY READ AND AGREED TO THE FOLLOWING TERMS AND CONDITIONS. THIS IS A
LEGAL AGREEMENT ("AGREEMENT") BETWEEN YOU (EITHER AN INDIVIDUAL OR AN ENTITY)
("YOU") AND ADVANCED MICRO DEVICES, INC. ("AMD").

IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, DO NOT INSTALL, COPY OR USE
THIS SOFTWARE. BY INSTALLING, COPYING OR USING THE SOFTWARE YOU AGREE TO ALL
THE TERMS AND CONDITIONS OF THIS AGREEMENT.

1.      DEFINITIONS.

     a) “Documentation” means install scripts and online or electronic
        documentation associated, included, or provided in connection with the
        Software, or any portion thereof.
     b) “Free Software License” means an open source or other license that
        requires, as a condition of use, modification or distribution, that any
        resulting software must be (a) disclosed or distributed in source code
        form; (b) licensed for the purpose of making derivative works; or (c)
        redistributable at no charge.
     c) “Intellectual Property Rights” means all copyrights, trademarks, trade
        secrets, patents, mask works, and all related, similar, or other
        intellectual property rights recognized in any jurisdiction worldwide,
        including all applications and registrations with respect thereto.
     d) “Object Code” means machine readable computer programming code files,
        which is not in a human readable form.
     e) “Software” means the enclosed AMD software program or any portion
        thereof that is provided to You.
     f) “Source Code” means computer programming code in human readable form and
        related system level documentation, including all comments, symbols and
        any procedural code such as job control language.

2.      LICENSE. Subject to the terms and conditions of this Agreement, AMD
hereby grants You a non-exclusive, royalty-free, revocable, non-transferable,
limited, copyright license to
     a) install and use the Software solely in Object Code form in conjunction
        with systems or components that include or incorporate AMD processors,
        as applicable; and
     b) Use and reference the Documentation, if any, solely in connection with
        the Software.

3.      RESTRICTIONS. Except for the limited license expressly granted in
Section 2 herein, You have no other rights in the Software, whether express,
implied, arising by estoppel or otherwise. Further restrictions regarding Your
use of the Software are set forth below. You may not:

     a) modify or create derivative works of the Software or Documentation;
     b) decompile, reverse engineer, disassemble or otherwise reduce the
        Software to Source Code form (except as allowed by applicable law);
     c) alter or remove any copyright, trademark or patent notice(s) in the
        Software or Documentation; or
     d) use the Software and Documentation to: (i) develop inventions directly
        derived from Confidential Information to seek patent protection; (ii)
        assist in the analysis of Your patents and patent applications; or (iii)
        modify existing patents; or
     e) use, modify and/or distribute any of the Software or Documentation so
        that any part becomes subject to a Free Software License.

4.      FEEDBACK. You have no obligation to give AMD any suggestions, comments
or other feedback (“Feedback”) relating to the Software or Documentation.
However, AMD may use and include any Feedback that it receives from You to
improve the Software, Documentation, or other AMD products, software, and
technologies. Accordingly, for any Feedback You provide to AMD, You grant AMD
and its affiliates and subsidiaries a worldwide, non-exclusive, irrevocable,
royalty-free, perpetual license to, directly or indirectly, use, reproduce,
license, sublicense, distribute, make, have made, sell and otherwise
commercialize the Feedback in the Software, Documentation, or other AMD
products, software and technologies. You further agree not to provide any
Feedback that (a) You know is subject to any Intellectual Property Rights of any
third party or (b) is subject to license terms which seek to require any
products incorporating or derived from such Feedback, or other AMD intellectual
property, to be licensed to or otherwise shared with any third party.

5.      OWNERSHIP AND COPYRIGHT OF SOFTWARE. The Software, including all
Intellectual Property Rights therein, and the Documentation are and remain the
sole and exclusive property of AMD or its licensors, and You shall have no
right, title or interest therein except as expressly set forth in this
Agreement.

6.      WARRANTY DISCLAIMER: THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS"
WITHOUT WARRANTY OF ANY KIND. AMD DISCLAIMS ALL WARRANTIES, EXPRESS, IMPLIED, OR
STATUTORY, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE, NON-INFRINGEMENT, THAT
THE SOFTWARE OR DOCUMENTATION WILL RUN UNINTERRUPTED OR ERROR-FREE OR WARRANTIES
ARISING FROM CUSTOM OF TRADE OR COURSE OF USAGE. THE ENTIRE RISK ASSOCIATED WITH
THE USE OF THE SOFTWARE AND DOCUMENTATION IS ASSUMED BY YOU. Some jurisdictions
do not allow the exclusion of implied warranties, so the above exclusion may not
apply to You.

7.      LIMITATION OF LIABILITY AND INDEMNIFICATION: AMD AND ITS LICENSORS WILL
NOT, UNDER ANY CIRCUMSTANCES BE LIABLE TO YOU FOR ANY PUNITIVE, DIRECT,
INCIDENTAL, INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING FROM USE OF THE
SOFTWARE, DOCUMENTATION, OR THIS AGREEMENT EVEN IF AMD AND ITS LICENSORS HAVE
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. In no event shall AMD's total
liability to You for all damages, losses, and causes of action (whether in
contract, tort (including negligence) or otherwise) exceed the amount of $100
USD. You agree to defend, indemnify and hold harmless AMD and its licensors, and
any of their directors, officers, employees, affiliates or agents from and
against any and all loss, damage, liability and other expenses (including
reasonable attorneys' fees), resulting from Your use of the Software,
Documentation, or violation of the terms and conditions of this Agreement.

8.      EXPORT RESTRICTIONS: You shall adhere to all applicable U.S.
import/export laws and regulations, as well as the import/export control laws
and regulations of other countries as applicable. You further agree to not
export, re-export, or transfer, directly or indirectly, any product, technical
data, software or source code received from AMD under this license, or the
direct product of such technical data or software to any country for which the
United States or any other applicable government requires an export license or
other governmental approval without first obtaining such licenses or approvals;
or in violation of any applicable laws or regulations of the United States or
the country where the technical data or software was obtained. You acknowledge
the technical data and software received will not, in the absence of
authorization from U.S. or local law and regulations as applicable, be used by
or exported, re-exported or transferred to: (i) any sanctioned or embargoed
country, or to nationals or residents of such countries; (ii) any restricted
end-user as identified on any applicable government end-user list; or (iii) any
party where the end-use involves nuclear, chemical/biological weapons, rocket
systems, or unmanned air vehicles. For the most current Country Group listings,
or for additional information about the EAR or Your obligations under those
regulations, please refer to the U.S. Bureau of Industry and Security’s website
at http://www.bis.doc.gov/.

9.      NOTICE TO U.S. GOVERNMENT END USERS. The Software and Documentation are
"commercial items", as that term is defined at 48 C.F.R. §2.101, consisting of
"commercial computer software" and "commercial computer software documentation",
as such terms are used in 48 C.F.R. §12.212 and 48 C.F.R. §227.7202,
respectively. Consistent with 48 C.F.R. §12.212 or 48 C.F.R. §227.7202-1 through
227.7202-4, as applicable, the commercial computer software and commercial
computer software documentation are being licensed to U.S. Government end users
(a) only as commercial items and (b) with only those rights as are granted to
all other end users pursuant to the terms and conditions set forth in this
Agreement. Unpublished rights are reserved under the copyright laws of the
United States.

10.     TERMINATION OF LICENSE. This Agreement will terminate immediately
without notice from AMD or judicial resolution if (1) You fail to comply with
any provisions of this Agreement, or (2) You provide AMD with notice that You
would like to terminate this Agreement. Upon termination of this Agreement, You
must delete or destroy all copies of the Software. Upon termination or
expiration of this Agreement, all provisions survive except for Section 2.

11.     SUPPORT AND UPDATES. AMD is under no obligation to provide any kind of
support under this Agreement. AMD may, in its sole discretion, provide You with
updates to the Software and Documentation, and such updates will be covered
under this Agreement. 

12.     GOVERNING LAW. This Agreement is made under and shall be construed
according to the laws of the State of California, excluding conflicts of law
rules. Each party submits to the jurisdiction of the state and federal courts of
Santa Clara County and the Northern District of California for the purposes of
this Agreement. You acknowledge that Your breach of this Agreement may cause
irreparable damage and agree that AMD shall be entitled to seek injunctive
relief under this Agreement, as well as such further relief as may be granted by
a court of competent jurisdiction.

13.     PRIVACY. We may be required under applicable data protection law to
provide you with certain information about who we are, how we process your
personal data and for what purposes and your rights in relation to your personal
information and how to exercise them. This information is provided in
www.amd.com/en/corporate/privacy. It is important that you read that
information. AMD’s Cookie Policy, sets out information about the cookies AMD
uses.

14.     GENERAL PROVISIONS. You may not assign this Agreement without the prior
written consent of AMD and any assignment without such consent will be null and
void. The parties do not intend that any agency or partnership relationship be
created between them by this Agreement. Each provision of this Agreement shall
be interpreted in such a manner as to be effective and valid under applicable
law. However, in the event that any provision of this Agreement becomes or is
declared unenforceable by any court of competent jurisdiction, such provision
shall be deemed deleted and the remainder of this Agreement shall remain in full
force and effect.

15.     ENTIRE AGREEMENT. This Agreement sets forth the entire agreement and
understanding between the parties with respect to the Software and supersedes
and merges all prior oral and written agreements, discussions and understandings
between them regarding the subject matter of this Agreement. No waiver or
modification of any provision of this Agreement shall be binding unless made in
writing and signed by an authorized representative of each party.

To help AMD improve Your graphics experience, AMD may collect non-personal
information, including the model of AMD graphics product, its device id, and
other system information.

If You agree to abide by the terms and conditions of this Agreement, please
press "Accept." If You do not agree to abide by the terms and conditions of this
Agreement and press "Decline," You may not use the Software.
EOF
    echo "---"
}

if [[ $* == *--accept-eula* ]]; then
    accepted=1
    echo "AMD EULA accepted by CLI argument."
elif [[ ! -z "$UNINSTALL" ]]; then
    accepted=1
else
    echo "In order to install AMF, you will need to agree to the AMD EULA."
    select yn in "Read license" "Cancel install"; do
        case $yn in
            "Read license" ) break;;
            "Cancel install" ) exit;;
        esac
    done

    status=$?
    if [ $status -ne 0 ]; then exit $status; fi

    amf_installer_show_eula

    echo "Do you agree to the terms of this EULA?"
    select yn in "Yes" "No" "Read license again"; do
        case $yn in
            "Yes" ) accepted=1; break;;
            "No" ) exit;;
            "Read license again" ) amf_installer_show_eula;;
        esac
    done

    status=$?
    if [ $status -ne 0 ]; then exit $status; fi
fi

# double-check accepted status
if [ $accepted -ne 1 ]; then
    exit 1
fi

test -e /etc/os-release && os_release='/etc/os-release' || os_release='/usr/lib/os-release'
. "${os_release}"

echo "$VERB AMF for driver 25.30 on ${PRETTY_NAME:-Linux}"

export AMF_REPO_URL="https://repo.radeon.com/amf/25.30"

if [ "${ID}" = "ubuntu" ]; then
    if [ "${VERSION_ID}" != "25.10" ] && [ "${VERSION_ID}" != "24.04" ] && [ "${VERSION_ID}" != "22.04" ]; then
        if [ "$FORCE_INSTALL" -ne 1 ]; then
            echo "Unsupported Ubuntu version ${VERSION_ID}"
            exit -1
        else
            # use the most up-to-date version
            VERSION_ID=25.10
            UBUNTU_CODENAME=questing
        fi
    fi
    apt-get remove -y amf-amdgpu-pro libamdenc-amdgpu-pro || true
    rm -rf /etc/apt/keyrings/amf-pub.asc || true
    rm -rf /etc/apt/sources.list.d/amf.list || true
    if [[ -z "$UNINSTALL" ]]; then
        apt-get install -y wget
        wget -qO - $AMF_REPO_URL/amf-pub.gpg | tee /etc/apt/keyrings/amf-pub.asc > /dev/null
        echo "deb [arch=amd64 signed-by=/etc/apt/keyrings/amf-pub.asc] $AMF_REPO_URL/ubuntu $UBUNTU_CODENAME main" | tee /etc/apt/sources.list.d/amf.list
        apt-get update
        apt-get install -y amf-amdgpu-pro libamdenc-amdgpu-pro
    fi
elif [ "${ID_LIKE#*suse*}" != "${ID_LIKE}" ]; then
    if [[ "${VERSION_ID}" != @(15.6|15.7) ]]; then
        if [ "$FORCE_INSTALL" -ne 1 ]; then
            echo "Unsupported SUSE version ${VERSION_ID}"
            exit -1
        else
            # use the most up-to-date version
            VERSION_ID=15.7
        fi
    fi
    zypper remove -y -f amf-amdgpu-pro libamdenc-amdgpu-pro || true
    zypper removerepo amf-repo || true
    if [[ -z "$UNINSTALL" ]]; then
        rpm -v --import $AMF_REPO_URL/amf-pub.gpg
        zypper addrepo -g -f -c $AMF_REPO_URL/sle/$VERSION_ID/packages/main/x86_64 amf-repo
        zypper refresh
        zypper install -y -f amf-amdgpu-pro libamdenc-amdgpu-pro
    fi
elif [ "${ID}" = "rhel" ]; then
    if [[ "${VERSION_ID}" != @(9.1|9.2|9.3|9.4|9.5|9.6|10.0) ]]; then
        if [ "$FORCE_INSTALL" -ne 1 ]; then
            echo "Unsupported RHEL version ${VERSION_ID}"
            exit -1
        else
            # use the most up-to-date version
            VERSION_ID=10.0
        fi
    fi
    yum remove -y amf-amdgpu-pro libamdenc-amdgpu-pro || true
    yum-config-manager --disable amf-repo || true
    if [[ -z "$UNINSTALL" ]]; then
        rpm -v --import $AMF_REPO_URL/amf-pub.gpg
        yum install -y yum-utils
        yum-config-manager --add-repo $AMF_REPO_URL/rhel/$VERSION_ID/packages/main/x86_64 amf-repo
        yum install -y amf-amdgpu-pro libamdenc-amdgpu-pro
    fi
else
    echo "Unrecognized linux distribution."
    exit -1
fi
